package ru.yandex.direct.core.entity.payment.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.payment.model.AutopaySettings;
import ru.yandex.direct.core.entity.payment.model.AutopaySettingsPaymethodType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.AUTOPAY_SETTINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
public class AutopaySettingsRepository {

    private static final JooqMapperWithSupplier<AutopaySettings> AUTOPAY_SETTINGS_MAPPER =
            JooqMapperWithSupplierBuilder.builder(AutopaySettings::new)
                    .map(property(AutopaySettings.WALLET_CID, AUTOPAY_SETTINGS.WALLET_CID))
                    .map(property(AutopaySettings.PAYER_UID, AUTOPAY_SETTINGS.PAYER_UID))
                    .map(convertibleProperty(AutopaySettings.PAYMENT_TYPE, AUTOPAY_SETTINGS.PAYMETHOD_TYPE,
                            AutopaySettingsPaymethodType::fromSource,
                            AutopaySettingsPaymethodType::toSource))
                    .map(property(AutopaySettings.CARD_ID, AUTOPAY_SETTINGS.PAYMETHOD_ID))
                    .map(property(AutopaySettings.REMAINING_SUM, AUTOPAY_SETTINGS.REMAINING_SUM))
                    .map(property(AutopaySettings.PAYMENT_SUM, AUTOPAY_SETTINGS.PAYMENT_SUM))
                    .map(property(AutopaySettings.TRIES_NUM, AUTOPAY_SETTINGS.TRIES_NUM))
                    .map(property(AutopaySettings.PERSON_ID, AUTOPAY_SETTINGS.PERSON_ID))
                    .map(property(AutopaySettings.LAST_CHANGE, AUTOPAY_SETTINGS.LAST_CHANGE))
                    .build();

    private final DslContextProvider dslContextProvider;

    @Autowired
    public AutopaySettingsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public AutopaySettings getAutopaySettings(int shard, long walletId) {
        return dslContextProvider.ppc(shard)
                .select(AUTOPAY_SETTINGS_MAPPER.getFieldsToRead())
                .from(AUTOPAY_SETTINGS)
                .where(AUTOPAY_SETTINGS.WALLET_CID.eq(walletId))
                .fetchOne(AUTOPAY_SETTINGS_MAPPER::fromDb);
    }

}
