package ru.yandex.direct.core.entity.performancefilter.container;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import static com.google.common.base.Preconditions.checkArgument;

public class DecimalRange {
    public static final String SEPARATOR = "-";

    private BigDecimal left;
    private BigDecimal right;

    @JsonCreator
    public DecimalRange(String value) {
        checkArgument(StringUtils.isNoneBlank(value), "cannot be blank");
        checkArgument(value.contains(SEPARATOR), "cannot be blank");
        String[] split = value.split(SEPARATOR, 2);
        if (NumberUtils.isNumber(split[0])) {
            left = new BigDecimal(split[0]);
        }
        if (NumberUtils.isNumber(split[1])) {
            right = new BigDecimal(split[1]);
        }
    }

    public BigDecimal getLeft() {
        return left;
    }

    public DecimalRange withLeft(BigDecimal left) {
        this.left = left;
        return this;
    }

    public BigDecimal getRight() {
        return right;
    }

    public DecimalRange withRight(BigDecimal right) {
        this.right = right;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DecimalRange that = (DecimalRange) o;
        return Objects.equals(left, that.left) && Objects.equals(right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(left, right);
    }
}
