package ru.yandex.direct.core.entity.performancefilter.container;

import java.util.List;

import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Контейнер для условий выбора smart-фильтров для APIv5.
 * В отличае от {@link PerformanceFiltersQueryFilter} результаты найденные по идентификаторам фильтров, групп и кампаний
 * пересекаются по ИЛИ. Так же, в отличае от {@link PerformanceFiltersQueryFilter}, статусы состояний фильтров
 * учитываются только для фильтрам найденных по номуру группы или кампании, фильтры указанные по id-фильтра возвращаются
 * независимо от статуса.
 */
public class PerformanceFilterSelectionCriteria {

    private boolean withDeleted = true;
    private boolean withNotSynced = true;
    private boolean withSuspended = true;
    private boolean withSynced = true;
    private LimitOffset limitOffset;
    private List<Long> perfFilterIds;
    private List<Long> adGroupIds;
    private List<Long> campaignIds;

    public boolean isWithDeleted() {
        return withDeleted;
    }

    public PerformanceFilterSelectionCriteria withoutDeleted() {
        this.withDeleted = false;
        return this;
    }

    public boolean isWithNotSynced() {
        return withNotSynced;
    }

    public PerformanceFilterSelectionCriteria withoutNotSynced() {
        this.withNotSynced = false;
        return this;
    }

    public boolean isWithSuspended() {
        return withSuspended;
    }

    public PerformanceFilterSelectionCriteria withoutSuspended() {
        this.withSuspended = false;
        return this;
    }

    public boolean isWithSynced() {
        return withSynced;
    }

    public PerformanceFilterSelectionCriteria withoutSynced() {
        this.withSynced = false;
        return this;
    }

    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    public PerformanceFilterSelectionCriteria withLimitOffset(LimitOffset limitOffset) {
        this.limitOffset = limitOffset;
        return this;
    }

    public PerformanceFilterSelectionCriteria withPerfFilterIds(List<Long> perfFilterIds) {
        this.perfFilterIds = perfFilterIds;
        return this;
    }

    public PerformanceFilterSelectionCriteria withAdGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public PerformanceFilterSelectionCriteria withCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public List<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public List<Long> getCampaignIds() {
        return campaignIds;
    }

    public List<Long> getPerfFilterIds() {
        return perfFilterIds;
    }
}
