package ru.yandex.direct.core.entity.performancefilter.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import com.google.common.collect.BiMap;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.AbstractPerformanceConditionValueParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NopeParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

public abstract class FilterSchema {
    private final Map<String, FilterSchemaFieldValidator> filterFieldValidatorsMap;
    private final BiMap<String, String> translations;
    protected final int minFiltersCount = 0;
    protected final int maxFiltersCount = 30;

    /**
     * Сейчас на UI чекбокс поля "available" показывается пользователям только если у схемы есть оба поля:
     * "available" и "categoryId". Возможно, это неправильно, но сейчас это так.
     */
    public static final String AVAILABLE = "available";

    public static final String URL_FIELD_NAME = "url";

    /**
     * Фиктивное имя схемы соответствующее тем фидам, для которых нет схемы.
     * В API и UI фильры для таких фидов выглядят как будто у них схема с пустым набором полей.
     */
    public static final String EMPTY_SCHEMA_NAME = "EmptySchema";

    protected FilterSchema(FilterSchemaBuilder filterSchemaBuilder) {
        this.filterFieldValidatorsMap = filterSchemaBuilder.validatorMap();
        translations = filterSchemaBuilder.translationsMap();
    }

    public abstract BusinessType businessType();

    public abstract FeedType feedType();

    public boolean isSiteSource() {
        return false;
    }

    @Nonnull
    public AbstractPerformanceConditionValueParser<?> getParser(String field, Operator operator) {
        FilterSchemaFieldValidator validator = filterFieldValidatorsMap.get(field);
        AbstractPerformanceConditionValueParser<?> parser = NopeParser.INSTANCE;
        if (validator != null && validator.getParser(operator) != null) {
            parser = validator.getParser(operator);
        }
        return parser;
    }

    public Set<String> allFields() {
        return filterFieldValidatorsMap.keySet();
    }

    public Map<String, FilterSchemaFieldValidator> getFilterFieldValidatorsMap() {
        return filterFieldValidatorsMap;
    }

    public int getMinFiltersCount() {
        return minFiltersCount;
    }

    public int getMaxFiltersCount() {
        return maxFiltersCount;
    }

    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, maxFiltersCount);
    }

    public String getFilterSchemaName() {
        return this.getClass().getSimpleName();
    }

    public String translateFieldNameFromGd(String gdName) {
        return translations.inverse().getOrDefault(gdName, gdName);
    }

    public String translateFieldNameForGd(String name) {
        return translations.getOrDefault(name, name);
    }
}
