package ru.yandex.direct.core.entity.performancefilter.schema;

import java.util.HashMap;
import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;

public class FilterSchemaBuilder {
    private final Map<String, FilterSchemaFieldValidator> validatorMap = new HashMap<>();
    private final BiMap<String, String> translations = HashBiMap.create();

    public FilterSchemaBuilder field(String field, FilterSchemaFieldValidator fieldValidator) {
        validatorMap.put(field, fieldValidator);
        return this;
    }

    public FilterSchemaBuilder field(String field, FilterSchemaFieldValidator fieldValidator, String gdName) {
        field(field, fieldValidator);
        translations.put(field, gdName);
        return this;
    }

    BiMap<String, String> translationsMap() {
        return translations;
    }

    Map<String, FilterSchemaFieldValidator> validatorMap() {
        return validatorMap;
    }
}
