package ru.yandex.direct.core.entity.performancefilter.schema;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.model.FieldParams;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.AbstractPerformanceConditionValueParser;

/**
 * todo javadoc
 */
public class FilterSchemaFieldValidator {
    private Map<Operator, AbstractPerformanceConditionValueParser<?>> parserByOperator;
    private FieldParams fieldParams;

    public FilterSchemaFieldValidator(Map<Operator, AbstractPerformanceConditionValueParser<?>> parserByOperator,
                                      FieldParams fieldParams) {
        this.parserByOperator = parserByOperator;
        this.fieldParams = fieldParams;
    }

    public AbstractPerformanceConditionValueParser<?> getParser(Operator operator) {
        return parserByOperator.get(operator);
    }

    public Set<Operator> getOperators() {
        return parserByOperator.keySet();
    }

    public FieldParams getFieldParams() {
        return fieldParams;
    }
}
