package ru.yandex.direct.core.entity.performancefilter.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.model.EnumFieldParams;
import ru.yandex.direct.core.entity.performancefilter.schema.model.FieldParams;
import ru.yandex.direct.core.entity.performancefilter.schema.model.NumberFieldParams;
import ru.yandex.direct.core.entity.performancefilter.schema.model.StringFieldParams;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.AbstractPerformanceConditionValueParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.BooleanStringParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.LongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneValuePrearrangedListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;

public class FilterSchemaFieldValidatorBuilder {
    private final List<Pair<Operator[], AbstractPerformanceConditionValueParser<?>>> operations = new ArrayList<>();
    private FieldParams fieldParams;

    private FilterSchemaFieldValidatorBuilder() {
    }

    public <T> FilterSchemaFieldValidatorBuilder restriction(AbstractPerformanceConditionValueParser<T> parser,
                                                             Operator... operators) {
        operations.add(Pair.of(operators, parser));
        if (fieldParams != null) {
            //todo mariachernova: Проверка, что существующие типы и параметры совпадают (DIRECT-92707)
        }
        if (fieldParams == null) {
            if (parser instanceof NumberListParser) {
                fieldParams = new NumberFieldParams((NumberListParser) parser);
            } else if (parser instanceof LongListParser) {
                fieldParams = new NumberFieldParams((LongListParser) parser);
            } else if (parser instanceof StringListParser) {
                fieldParams = new StringFieldParams((StringListParser) parser);
            } else if (parser instanceof OneValuePrearrangedListParser) {
                fieldParams = new EnumFieldParams((OneValuePrearrangedListParser) parser);
            } else if (parser instanceof BooleanStringParser) {
                fieldParams = new EnumFieldParams(ImmutableSet.of("true"));
            }
        }
        return this;
    }

    public FilterSchemaFieldValidator build() {
        Map<Operator, AbstractPerformanceConditionValueParser<?>> parserByOperator = new HashMap<>();
        for (Pair<Operator[], AbstractPerformanceConditionValueParser<?>> operation : operations) {
            for (Operator operator : operation.getLeft()) {
                parserByOperator.put(operator, operation.getRight());
            }
        }
        return new FilterSchemaFieldValidator(parserByOperator, fieldParams);
    }

    public static FilterSchemaFieldValidatorBuilder validator() {
        return new FilterSchemaFieldValidatorBuilder();
    }
}
