package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class AutoAutoRu extends FilterSchema {

    private static final String MARK_ID = "mark_id";
    private static final String FOLDER_ID = "folder_id";
    private static final String BODY_TYPE = "body_type";
    private static final String WHEEL = "wheel";
    private static final String COLOR = "color";
    private static final String METALLIC = "metallic";
    private static final String AVAILABILITY = "availability";
    private static final String YEAR = "year";
    private static final String URL = "url";
    private static final String PRICE = "price";

    private static final StringListParser DEFAULT_STRING_LIST_PARSER = new StringListParser.Builder()
            .withMinItemCount(1)
            .withMaxItemCount(100)
            .withMaxStringLength(175)
            .build();

    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(MARK_ID, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(FOLDER_ID, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(BODY_TYPE, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(WHEEL, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS)
                    .build())
            .field(COLOR, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(METALLIC, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS)
                    .build())
            .field(AVAILABILITY, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS)
                    .build())
            .field(YEAR, validator()
                    .restriction(new NumberListParser.Builder()
                                    .withMaxItemCount(1)
                                    .withMaxItemCount(10)
                                    .withMinValue(1970)
                                    .build(),
                            Operator.EQUALS)
                    .build())
            .field(URL, validator()
                    // TODO sagid-m@ Add URL restriction and use it with .EQUALS
                    .restriction(StringListParser.INSTANCE, Operator.EQUALS)
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(PRICE, validator()
                    .restriction(
                            new NumberListParser.Builder().withMaxItemCount(1).build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(new NumberListParser.Builder()
                                    .withMinItemCount(1)
                                    .withMaxItemCount(100)
                                    .withPrecision(0)
                                    .withMinValue(0)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(new DecimalRangeListParser.Builder()
                                    .withPrecision(0)
                                    .withMinItemCount(1)
                                    .withMaxItemCount(10)
                                    .build(),
                            Operator.RANGE)
                    .build());

    protected AutoAutoRu() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.AUTO;
    }

    @Override
    public FeedType feedType() {
        return FeedType.AUTO_RU;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
