package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.LongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneLongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneNumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneValuePrearrangedListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class HotelsGoogleHotelsSchema extends FilterSchema {

    private static final String PRICE = "Price";
    private static final String DESCRIPTION = "Description";
    private static final String NAME = "name";
    private static final String LOCATION = "location";
    private static final String CLASS = "class";
    private static final String URL = "url";
    private static final String OFFER_ID = "OfferID";
    private static final String SCORE = "score";
    private static final String MAX_SCORE = "max_score";
    private static final StringListParser likeableString = new StringListParser.Builder()
            .withMinItemCount(1)
            .withMaxItemCount(100)
            .withMaxStringLength(175)
            .build();
    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(PRICE, validator()
                    .restriction(new OneNumberListParser.Builder()
                                    .withMinValue(0)
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(new NumberListParser.Builder()
                                    .withMinItemCount(1)
                                    .withMaxItemCount(100)
                                    .withMinValue(0)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE, Operator.RANGE)
                    .build())
            .field(DESCRIPTION, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(NAME, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(LOCATION, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(CLASS, validator()
                    .restriction(new OneValuePrearrangedListParser.Builder()
                                    .values("1", "2", "3", "4", "5")
                                    .build(),
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(URL, validator()
                    .restriction(StringListParser.INSTANCE, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(OFFER_ID, validator()
                    .restriction(new OneLongListParser.Builder()
                                    .withMinValue(0)
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(new LongListParser.Builder()
                                    .withMinValue(0)
                                    .withMinItemCount(1)
                                    .withMaxItemCount(100)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.INTEGER_RANGE,
                            Operator.RANGE)
                    .build())
            .field(SCORE, validator()
                    .restriction(
                            new OneNumberListParser.Builder().withPrecision(0).build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(new NumberListParser.Builder()
                                    .withPrecision(0)
                                    .withMinValue(0)
                                    .withMinItemCount(1)
                                    .withMaxItemCount(100)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.INTEGER_RANGE,
                            Operator.RANGE)
                    .build())
            .field(MAX_SCORE, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build());

    protected HotelsGoogleHotelsSchema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.HOTELS;
    }

    @Override
    public FeedType feedType() {
        return FeedType.GOOGLE_HOTELS;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
