package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidator;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class OtherGoogleCustomSchema extends FilterSchema {

    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String SECOND_TITLE = "second_title";
    private static final String DESCRIPTION = "description";
    private static final String CATEGORY = "category";
    private static final String PRICE = "price";
    private static final String SALE_PRICE = "sale_price";

    private static final StringListParser DEFAULT_STRING_LIST_PARSER = new StringListParser.Builder()
            .withMinItemCount(1)
            .withMaxItemCount(100)
            .withMaxStringLength(175)
            .build();
    private static final FilterSchemaFieldValidator PRICE_OR_RANGE = validator()
            .restriction(new NumberListParser.Builder()
                            .withPrecision(2)
                            .withMaxItemCount(1)
                            .build(),
                    Operator.GREATER,
                    Operator.LESS)
            .restriction(new NumberListParser.Builder()
                            .withMinItemCount(1)
                            .withMaxItemCount(100)
                            .withPrecision(2)
                            .withMinValue(0)
                            .build(),
                    Operator.EQUALS)
            .restriction(new DecimalRangeListParser.Builder()
                            .withMinItemCount(1)
                            .withPrecision(2)
                            .withMaxItemCount(10)
                            .build(),
                    Operator.RANGE)
            .build();
    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(NAME, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(URL, validator()
                    // TODO sagid-m@ Add URL restriction and use it with .EQUALS
                    .restriction(StringListParser.INSTANCE, Operator.EQUALS)
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(SECOND_TITLE, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(DESCRIPTION, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(CATEGORY, validator()
                    .restriction(DEFAULT_STRING_LIST_PARSER, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(PRICE, PRICE_OR_RANGE)
            .field(SALE_PRICE, PRICE_OR_RANGE);

    protected OtherGoogleCustomSchema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.OTHER;
    }

    @Override
    public FeedType feedType() {
        return FeedType.GOOGLE_CUSTOM;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
