package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class OtherYandexCustomSchema extends FilterSchema {

    private static final String URL = "url";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String PRICE = "price";
    private static final String OLD_PRICE = "oldprice";

    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(URL, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.EQUALS,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build())
            .field(DESCRIPTION, validator()
                    .restriction(StringListParser.INSTANCE, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(NAME, validator()
                    .restriction(StringListParser.INSTANCE, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build(), "Title")
            .field(PRICE, validator()
                    .restriction(
                            new NumberListParser.Builder().withMaxItemCount(1).build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(NumberListParser.INSTANCE, Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE, Operator.RANGE)
                    .build())
            .field(OLD_PRICE, validator()
                    .restriction(
                            new NumberListParser.Builder().withMaxItemCount(1).build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(NumberListParser.INSTANCE, Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE, Operator.RANGE)
                    .build());

    public OtherYandexCustomSchema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.OTHER;
    }

    @Override
    public FeedType feedType() {
        return FeedType.YANDEX_CUSTOM;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
