package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;

/**
 * Сейчас эта схема в точности совпадает со схемой {@code retail_YandexMarket},
 * которая описана в {@link PerformanceDefault}
 */
@Component
public class OtherYandexMarket extends FilterSchema {

    protected OtherYandexMarket() {
        super(PerformanceDefault.BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.OTHER;
    }

    @Override
    public FeedType feedType() {
        return FeedType.YANDEX_MARKET;
    }
}
