package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.BooleanParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.BooleanStringParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.LongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneLongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneValuePrearrangedListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class PerformanceDefault extends FilterSchema {

    private static final String ID = "id";

    public static final String CATEGORY_ID = "categoryId";

    private static final String VENDOR = "vendor";

    private static final String MODEL = "model";

    private static final String URL = "url";

    private static final String NAME = "name";

    public static final String PRICE = "price";

    private static final String TYPE_PREFIX = "typePrefix";

    private static final String DESCRIPTION = "description";

    private static final String ADULT = "adult";

    private static final String AGE = "age";

    private static final String MANUFACTURER_WARRANTY = "manufacturer_warranty";

    private static final String MARKET_CATEGORY = "market_category";

    private static final String OLD_PRICE = "oldprice";

    private static final String STORE = "store";

    public static final String PICKUP = "pickup";

    public PerformanceDefault() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.RETAIL;
    }

    @Override
    public FeedType feedType() {
        return FeedType.YANDEX_MARKET;
    }

    static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(CATEGORY_ID, validator()
                    .restriction(new LongListParser.Builder()
                                    .withMaxItemCount(20000)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(new OneLongListParser.Builder()
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(DecimalRangeListParser.INTEGER_RANGE,
                            Operator.RANGE)
                    .build())
            .field(VENDOR, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(MODEL, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build())
            .field(URL, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.EQUALS,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build())
            .field(NAME, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build())
            .field(PRICE, validator()
                    .restriction(new NumberListParser.Builder()
                                    .withMaxItemCount(1)
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(NumberListParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE,
                            Operator.RANGE)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(ID, validator()
                            .restriction(new OneLongListParser.Builder()
                                            .build(),
                                    Operator.GREATER,
                                    Operator.LESS)
                            .restriction(new LongListParser.Builder()
                                            //todo проверить валидацию
//                                    .withMaxItemCount(50)
                                            .build(),
                                    Operator.EQUALS)
                            .restriction(DecimalRangeListParser.INTEGER_RANGE,
                                    Operator.RANGE)
                            .build()
            )
            .field(TYPE_PREFIX, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(DESCRIPTION, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build())
            .field(ADULT, validator()
                    .restriction(BooleanParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(AGE, validator()
                    .restriction(new OneValuePrearrangedListParser.Builder()
                                    .values("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "16", "18")
                                    .build(),
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(MANUFACTURER_WARRANTY, validator()
                    .restriction(BooleanParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(MARKET_CATEGORY, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(OLD_PRICE, validator()
                    .restriction(new NumberListParser.Builder()
                                    .withMaxItemCount(1)
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(NumberListParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE,
                            Operator.RANGE)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(PICKUP, validator()
                    .restriction(BooleanStringParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(STORE, validator()
                    .restriction(BooleanParser.INSTANCE,
                            Operator.EQUALS)
                    .restriction(ExistsParser.INSTANCE,
                            Operator.EXISTS)
                    .build())
            .field(AVAILABLE, validator()
                    .restriction(BooleanStringParser.INSTANCE,
                            Operator.EQUALS)
                    .build()
            );
}
