package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneNumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneValuePrearrangedListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;


@Component
public class RetailGoogleMerchantSchema extends FilterSchema {
    private static final String LINK = "link";
    private static final String BRAND = "brand";
    private static final String PRICE = "price";
    private static final String DESCRIPTION = "description";
    private static final String AVAILABILITY = "availability";
    private static final StringListParser likeableString = new StringListParser.Builder()
            .withMinItemCount(1)
            .withMaxItemCount(100)
            .withMaxStringLength(175)
            .build();
    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(BRAND, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(LINK, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(new StringListParser.Builder()
                                    // TODO sagid-m@ Add URL validation
                                    .build(),
                            Operator.EQUALS)
                    .build())
            .field(PRICE, validator()
                    .restriction(new OneNumberListParser.Builder()
                                    .withMinValue(0)
                                    .build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(new NumberListParser.Builder()
                                    .withMinItemCount(1)
                                    .withMaxItemCount(100)
                                    .withMinValue(0)
                                    .build(),
                            Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE, Operator.RANGE)
                    .build())
            .field(DESCRIPTION, validator()
                    .restriction(likeableString, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .build())
            .field(AVAILABILITY, validator()
                    .restriction(new OneValuePrearrangedListParser.Builder()
                                    .values("in stock", "out stock")
                                    .build(),
                            Operator.EQUALS)
                    .build());

    public RetailGoogleMerchantSchema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.RETAIL;
    }

    @Override
    public FeedType feedType() {
        return FeedType.GOOGLE_MERCHANT;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
