package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidator;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.OneNumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.CollectionConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

@Component
public class RetailTurkeyClient25Schema extends FilterSchema {

    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String DISCOUNT_AMOUNT = "discount_amount";
    private static final String CPC_TARGET = "cpc_target";
    private static final String DOMAIN = "domain";
    private static final String MERCHANT_NAME = "merchant_name";
    private static final String CONDITIONS = "conditions";
    private static final String GEO_TARGET = "geo_target";
    private static final String AUDITORY_TARGET = "auditory_target";
    private static final String DESCRIPTION = "description";
    private static final String DISCOUNT_TYPE = "discount_type";

    private static final FilterSchemaFieldValidator positiveIntOrRange = validator()
            .restriction(new OneNumberListParser.Builder()
                            .withPrecision(0)
                            .withMinValue(0)
                            .build(),
                    Operator.LESS, Operator.GREATER)
            .restriction(new NumberListParser.Builder()
                            .withPrecision(0)
                            .withMinValue(0)
                            .build(),
                    Operator.EQUALS)
            .restriction(DecimalRangeListParser.INTEGER_RANGE,
                    Operator.RANGE)
            .build();
    private static final FilterSchemaFieldValidator likeableStringOrExists = validator()
            .restriction(new StringListParser.Builder()
                            .withMaxStringLength(175)
                            .build(),
                    Operator.CONTAINS, Operator.NOT_CONTAINS)
            .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
            .build();
    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(CAMPAIGN_ID, positiveIntOrRange)
            .field(DISCOUNT_AMOUNT, positiveIntOrRange)
            .field(CPC_TARGET, positiveIntOrRange)
            .field(DESCRIPTION, validator()
                    .restriction(StringListParser.INSTANCE, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build())
            .field(DOMAIN, validator()
                    .restriction(new StringListParser.Builder()
                                    .withMaxStringLength(175)
                                    .build(),
                            Operator.CONTAINS, Operator.NOT_CONTAINS)
                    // TODO sagid-m@ Add a URL restriction on equality
                    .restriction(StringListParser.INSTANCE, Operator.EQUALS)
                    .build())
            .field(MERCHANT_NAME, likeableStringOrExists)
            .field(CONDITIONS, likeableStringOrExists)
            .field(GEO_TARGET, likeableStringOrExists)
            .field(AUDITORY_TARGET, likeableStringOrExists)
            .field(DESCRIPTION, likeableStringOrExists)
            .field(DISCOUNT_TYPE, likeableStringOrExists);

    protected RetailTurkeyClient25Schema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.RETAIL;
    }

    @Override
    public FeedType feedType() {
        return FeedType.TURKEY_CLIENT_25;
    }

    @Override
    public <T> Constraint<List<T>, Defect> validFiltersCount() {
        return CollectionConstraints.collectionSize(minFiltersCount, 10);
    }
}
