package ru.yandex.direct.core.entity.performancefilter.schema.compiled;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.performancefilter.model.Operator;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema;
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaBuilder;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.DecimalRangeListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.ExistsParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;

import static ru.yandex.direct.core.entity.performancefilter.schema.FilterSchemaFieldValidatorBuilder.validator;

/**
 * Схема фильтров для смарта по сайту
 */
@Component
public class SiteSchema extends FilterSchema {

    private static final String NAME = "name";
    private static final String SHOW_NAME = "Заголовок";

    private static final String URL = "url";
    private static final String SHOW_URL = "Ссылка на товар";

    private static final String PRICE = "price";
    private static final String SHOW_PRICE = "Цена";

    private static final FilterSchemaBuilder BUILDER = new FilterSchemaBuilder()
            .field(NAME, validator()
                    .restriction(StringListParser.INSTANCE, Operator.CONTAINS, Operator.NOT_CONTAINS)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build(), SHOW_NAME)
            .field(URL, validator()
                    .restriction(StringListParser.INSTANCE,
                            Operator.EQUALS,
                            Operator.CONTAINS,
                            Operator.NOT_CONTAINS)
                    .build(), SHOW_URL)
            .field(PRICE, validator()
                    .restriction(
                            new NumberListParser.Builder().withMaxItemCount(1).build(),
                            Operator.GREATER,
                            Operator.LESS)
                    .restriction(NumberListParser.INSTANCE, Operator.EQUALS)
                    .restriction(DecimalRangeListParser.PRICE_RANGE, Operator.RANGE)
                    .restriction(ExistsParser.INSTANCE, Operator.EXISTS)
                    .build(), SHOW_PRICE);

    public SiteSchema() {
        super(BUILDER);
    }

    @Override
    public BusinessType businessType() {
        return BusinessType.RETAIL;
    }

    @Override
    public FeedType feedType() {
        return null;
    }

    @Override
    public boolean isSiteSource() {
        return true;
    }
}
