package ru.yandex.direct.core.entity.performancefilter.schema.model;

import ru.yandex.direct.core.entity.performancefilter.schema.parser.LongListParser;
import ru.yandex.direct.core.entity.performancefilter.schema.parser.NumberListParser;

public class NumberFieldParams extends FieldParams {
    private final double minValue;
    private final double maxValue;
    private final int precision;

    public NumberFieldParams(NumberListParser parser) {
        this(parser.getMinValue(), parser.getMaxValue(), parser.getPrecision());
    }

    public NumberFieldParams(LongListParser parser) {
        this(parser.getMinValue(), parser.getMaxValue(), 0);
    }

    private NumberFieldParams(double minValue, double maxValue, int precision) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.precision = precision;
    }

    public double getMinValue() {
        return minValue;
    }

    public double getMaxValue() {
        return maxValue;
    }

    public int getPrecision() {
        return precision;
    }
}
