package ru.yandex.direct.core.entity.performancefilter.schema.model;

import ru.yandex.direct.core.entity.performancefilter.schema.parser.StringListParser;

public class StringFieldParams extends FieldParams {
    private final int minStringLength;
    private final int maxStringLength;

    public StringFieldParams(StringListParser parser) {
        this(parser.getMinStringLength(), parser.getMaxStringLength());
    }

    public StringFieldParams(int minStringLength, int maxStringLength) {
        this.minStringLength = minStringLength;
        this.maxStringLength = maxStringLength;
    }

    public int getMinStringLength() {
        return minStringLength;
    }

    public int getMaxStringLength() {
        return maxStringLength;
    }
}
