package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import java.io.Serializable;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.defect.CommonDefects.invalidFormat;

public abstract class AbstractPerformanceConditionValueParser<V> implements Serializable {
    protected static final Defect INVALID_FORMAT_DEFECT = invalidFormat();

    protected abstract V parseInternal(String value);

    public abstract boolean isParsable(String value);

    public abstract ValidationResult<PerformanceFilterCondition, Defect> validate(
            PerformanceFilterCondition<V> value);

    public Constraint<String, Defect> validFormat() {
        return Constraint.fromPredicate(this::isParsable, INVALID_FORMAT_DEFECT);
    }

    @Nullable
    public V parse(PerformanceFilterCondition<V> condition) {
        if (isParsable(condition.getStringValue())) {
            return parseInternal(condition.getStringValue());
        }
        return null;
    }
}
