package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

public class BooleanStringParser extends AbstractPerformanceConditionValueParser<Boolean> {
    public static final BooleanStringParser INSTANCE = new BooleanStringParser();

    @Override
    protected Boolean parseInternal(String value) {
        return JsonUtils.fromJson(value, Boolean.class);
    }

    @Override
    public boolean isParsable(String value) {
        try {
            parseInternal(value);
        } catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public ValidationResult<PerformanceFilterCondition, Defect> validate(PerformanceFilterCondition<Boolean> value) {
        ModelItemValidationBuilder<PerformanceFilterCondition> vb = ModelItemValidationBuilder.of(value);
        vb.item(PerformanceFilterCondition.STRING_VALUE)
                .check(validFormat());
        return vb.getResult();
    }
}
