package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import ru.yandex.direct.core.entity.performancefilter.container.Exists;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

public class ExistsParser extends AbstractPerformanceConditionValueParser<Exists> {
    public static final ExistsParser INSTANCE = new ExistsParser();

    @Override
    protected Exists parseInternal(String value) {
        return new Exists("1".equals(value));
    }

    @Override
    public boolean isParsable(String value) {
        try {
            parseInternal(value);
        } catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public ValidationResult<PerformanceFilterCondition, Defect> validate(
            PerformanceFilterCondition value) {
        ModelItemValidationBuilder<PerformanceFilterCondition> vb = ModelItemValidationBuilder.of(value);
        vb.item(PerformanceFilterCondition.STRING_VALUE)
                .check(validFormat());
        return vb.getResult();
    }
}
