package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class NopeParser extends AbstractPerformanceConditionValueParser<Object> {
    public static final NopeParser INSTANCE = new NopeParser();

    @Override
    protected Object parseInternal(String value) {
        return null;
    }

    @Override
    public boolean isParsable(String value) {
        return false;
    }

    @Override
    public ValidationResult<PerformanceFilterCondition, Defect> validate(PerformanceFilterCondition<Object> value) {
        return ValidationResult.failed(value, CommonDefects.invalidFormat());
    }
}
