package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import java.util.List;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.StringDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition.PARSED_VALUE;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.listSize;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public abstract class ObjectListParser<T> extends AbstractPerformanceConditionValueParser<List<T>> {
    public static final int MIN_ITEM_COUNT = 1;
    //todo проверить валидацию
    public static final int MAX_ITEM_COUNT = 100;


    final int minItemCount;
    final int maxItemCount;

    ObjectListParser(int minItemCount, int maxItemCount) {
        this.minItemCount = minItemCount;
        this.maxItemCount = maxItemCount;
    }

    public int getMinItemCount() {
        return minItemCount;
    }

    public int getMaxItemCount() {
        return maxItemCount;
    }

    @Override
    public boolean isParsable(String value) {
        try {
            parseInternal(value);
        } catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public ValidationResult<PerformanceFilterCondition, Defect> validate(PerformanceFilterCondition<List<T>> value) {
        ModelItemValidationBuilder<PerformanceFilterCondition> vb = ModelItemValidationBuilder.of(value);
        vb.item(PerformanceFilterCondition.STRING_VALUE)
                .check(validFormat());
        if (vb.getResult().hasAnyErrors()) {
            return vb.getResult();
        }
        vb.list(value.getParsedValue(), PARSED_VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isTrue(minItemCount > 0))
                .check(listSize(minItemCount, maxItemCount), When.isValid())
                .checkEach(notNull(), When.isValid())
                .checkEach(Constraint.fromPredicate(v -> !String.valueOf(v).isEmpty(), StringDefects.notEmptyString()),
                        When.isValid());
        return vb.getResult();
    }
}
