package ru.yandex.direct.core.entity.performancefilter.schema.parser;

public class OneLongListParser extends LongListParser {
    protected OneLongListParser(long minValue, long maxValue) {
        super(1, 1, minValue, maxValue);
    }

    public static class Builder {
        private long minValue = 0;
        private long maxValue = Long.MAX_VALUE;

        public Builder withMinValue(long minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder withMaxValue(long maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public OneLongListParser build() {
            return new OneLongListParser(minValue, maxValue);
        }
    }
}
