package ru.yandex.direct.core.entity.performancefilter.schema.parser;

public class OneNumberListParser extends NumberListParser {
    protected OneNumberListParser(double minValue, double maxValue, int precision) {
        super(1, 1, minValue, maxValue, precision);
    }

    public static class Builder {
        private int precision = DEFAULT_PRECISION;

        private double minValue = 0;
        private double maxValue = Long.MAX_VALUE;

        public Builder withMinValue(long minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder withMaxValue(long maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder withPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public OneNumberListParser build() {
            return new OneNumberListParser(minValue, maxValue, precision);
        }
    }
}
