package ru.yandex.direct.core.entity.performancefilter.schema.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition.PARSED_VALUE;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

public class OneValuePrearrangedListParser extends ObjectListParser<String> {
    private static final TypeReference<List<String>> TYPE_REFERENCE = new TypeReference<List<String>>() {
    };
    private final Set<String> enumValues;


    protected OneValuePrearrangedListParser(Set<String> enumValues) {
        super(1, 1);
        this.enumValues = ImmutableSet.copyOf(enumValues);
    }

    public Set<String> getEnumValues() {
        return enumValues;
    }

    @Override
    public ValidationResult<PerformanceFilterCondition, Defect> validate(
            PerformanceFilterCondition<List<String>> value) {
        ModelItemValidationBuilder<PerformanceFilterCondition> vb = ModelItemValidationBuilder.of(value);
        vb.checkBy(super::validate);
        if (vb.getResult().hasAnyErrors()) {
            return vb.getResult();
        }

        vb.list(value.getParsedValue(), PARSED_VALUE)
                .checkEach(inSet(enumValues));
        return vb.getResult();
    }

    @Override
    protected List<String> parseInternal(String value) {
        return JsonUtils.fromJson(value, TYPE_REFERENCE);
    }

    public static class Builder {
        private Set<String> enumValues = new HashSet<>();

        public Builder values(String... values) {
            enumValues.addAll(Arrays.asList(values));
            return this;
        }

        public OneValuePrearrangedListParser build() {
            return new OneValuePrearrangedListParser(enumValues);
        }
    }
}
