package ru.yandex.direct.core.entity.performancefilter.service;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class PerformanceFilterDefects {

    public static Defect inconsistentCampaignStrategy() {
        return new Defect<>(PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY);
    }

    public static Defect filterConditionsIsTooLong() {
        return new Defect<>(PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG);
    }

    public static Defect mustContainAnyMoreConditions() {
        return new Defect<>(PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS);
    }

    public static Defect<Void> invalidOperator() {
        return new Defect<>(PerformanceFilterDefectIds.INVALID_OPERATOR);
    }

    public static Defect<Void> unknownOperator() {
        return new Defect<>(PerformanceFilterDefectIds.UNKNOWN_OPERATOR);
    }

    public static Defect<Void> unknownField() {
        return new Defect<>(PerformanceFilterDefectIds.UNKNOWN_FIELD);
    }


    public enum PerformanceFilterDefectIds implements DefectId<Void> {
        INCONSISTENT_CAMPAIGN_STRATEGY,
        FILTER_CONDITIONS_IS_TOO_LONG,
        MUST_CONTAIN_ANY_MORE_CONDITIONS,
        INVALID_OPERATOR,
        UNKNOWN_OPERATOR,
        UNKNOWN_FIELD
    }

    public enum PerformanceFilterNumberDefectIds implements DefectId<NumberDefectParams> {
        FILTER_COUNT_IS_TOO_LARGE
    }

    public static Defect filterCountIsTooLarge(Number max) {
        return new Defect<>(PerformanceFilterNumberDefectIds.FILTER_COUNT_IS_TOO_LARGE,
                new NumberDefectParams().withMax(max));
    }

}
