package ru.yandex.direct.core.entity.performancefilter.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.performancefilter.model.RetargetingConditionConnectedByPerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.repository.PerformanceFilterRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между списком фильтров и Retargeting Condition
 */
@ParametersAreNonnullByDefault
@Service
public class PerformanceFilterOfRetargetingConditionService
        implements RelationshipService<RetargetingConditionConnectedByPerformanceFilter, Long, Long> {
    private final ShardHelper shardHelper;
    private final PerformanceFilterRepository performanceFilterRepository;

    @Autowired
    public PerformanceFilterOfRetargetingConditionService(ShardHelper shardHelper,
                                                          PerformanceFilterRepository performanceFilterRepository) {
        this.shardHelper = shardHelper;
        this.performanceFilterRepository = performanceFilterRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> retCondIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(performanceFilterRepository.getFilterIdsByRetargetingConditionIds(shard, retCondIds).values())
                .flatMap(StreamEx::of)
                .toSet();
    }
}
