package ru.yandex.direct.core.entity.performancefilter.service;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupSimple;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.currency.Currency;

public class PerformanceFilterValidationContainer {
    private Map<Long, Campaign> campaignsByAdGroupId;
    private Currency clientWorkCurrency;
    private Map<Long, AdGroupSimple> adGroupsById;
    private Map<Long, List<PerformanceFilter>> oldFiltersByAdGroupId;
    private Map<Long, PerformanceFilter> oldFiltersById;

    public Map<Long, Campaign> getCampaignsByAdGroupId() {
        return campaignsByAdGroupId;
    }

    public PerformanceFilterValidationContainer withCampaignsByAdGroupId(
            Map<Long, Campaign> campaignsByAdGroupId) {
        this.campaignsByAdGroupId = campaignsByAdGroupId;
        return this;
    }

    public Currency getClientWorkCurrency() {
        return clientWorkCurrency;
    }

    public PerformanceFilterValidationContainer withClientWorkCurrency(
            Currency clientWorkCurrency) {
        this.clientWorkCurrency = clientWorkCurrency;
        return this;
    }

    public Map<Long, AdGroupSimple> getAdGroupsById() {
        return adGroupsById;
    }

    public PerformanceFilterValidationContainer withAdGroupsById(Map<Long, AdGroupSimple> adGroupsById) {
        this.adGroupsById = adGroupsById;
        return this;
    }

    public Map<Long, List<PerformanceFilter>> getOldFiltersByAdGroupId() {
        return oldFiltersByAdGroupId;
    }

    public PerformanceFilterValidationContainer withOldFiltersByAdGroupId(
            Map<Long, List<PerformanceFilter>> oldFiltersByAdGroupId) {
        this.oldFiltersByAdGroupId = oldFiltersByAdGroupId;
        return this;
    }

    public Map<Long, PerformanceFilter> getOldFiltersById() {
        return oldFiltersById;
    }

    public PerformanceFilterValidationContainer withOldFilters(Map<Long, PerformanceFilter> oldFiltersById) {
        this.oldFiltersById = oldFiltersById;
        return this;
    }
}
