package ru.yandex.direct.core.entity.performancefilter.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.bids.container.SetBidSelectionType;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;

public class SetBidItemSearcher {

    private final Map<SetBidId, SetBidItem> setBidItemById;

    public SetBidItemSearcher(Collection<SetBidItem> items) {
        setBidItemById = items.stream()
                .collect(toMap(this::getSetBidId, identity()));
    }

    private SetBidId getSetBidId(SetBidItem item) {
        if (item.getId() != null) {
            return new SetBidId(item.getId(), SetBidSelectionType.KEYWORD_ID);
        }
        if (item.getAdGroupId() != null) {
            return new SetBidId(item.getAdGroupId(), SetBidSelectionType.AD_GROUP_ID);
        }
        if (item.getCampaignId() != null) {
            return new SetBidId(item.getCampaignId(), SetBidSelectionType.CAMPAIGN_ID);
        }
        throw new IllegalStateException();
    }

    public SetBidItem get(@Nullable Long id, @Nullable Long adgroupId, @Nullable Long campaignId) {
        List<SetBidId> setBidIds = EntryStream.of(
                SetBidSelectionType.KEYWORD_ID, id,
                SetBidSelectionType.AD_GROUP_ID, adgroupId,
                SetBidSelectionType.CAMPAIGN_ID, campaignId)
                .nonNullValues()
                .map(entry -> new SetBidId(entry.getValue(), entry.getKey()))
                .toList();
        for (SetBidId setBidId : setBidIds) {
            SetBidItem setBidItem = setBidItemById.get(setBidId);
            if (setBidItem != null) {
                return setBidItem;
            }
        }
        return null;
    }

    private static class SetBidId {
        private final long id;
        private final SetBidSelectionType selectionType;

        SetBidId(long id, SetBidSelectionType selectionType) {
            this.id = id;
            this.selectionType = selectionType;
        }

        @Override
        public boolean equals(Object obj) {
            SetBidId setBidId = obj instanceof SetBidId ? (SetBidId) obj : null;
            return setBidId != null &&
                    id == setBidId.id &&
                    selectionType == setBidId.selectionType;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(id) ^ selectionType.hashCode();
        }

    }

}
