package ru.yandex.direct.core.entity.phrase;

import java.util.Objects;

/**
 * Инкапсулирует фразу, ее нормальную форму и
 * признак 'существовала ли фраза в нормальной форме до того как ее попытались добавить к группе/кампании/etc'
 */
public class NormalizedPhrasePair {
    private String origPhrase;
    private String normalizedPhrase;

    public NormalizedPhrasePair() {
    }

    public NormalizedPhrasePair(String origPhrase, String normalizedPhrase) {
        this.origPhrase = origPhrase;
        this.normalizedPhrase = normalizedPhrase;
    }

    public void setOrigPhrase(String origPhrase) {
        this.origPhrase = origPhrase;
    }

    public void setNormalizedPhrase(String normalizedPhrase) {
        this.normalizedPhrase = normalizedPhrase;
    }

    public String getOrigPhrase() {
        return origPhrase;
    }

    public String getNormalizedPhrase() {
        return normalizedPhrase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NormalizedPhrasePair that = (NormalizedPhrasePair) o;
        return Objects.equals(origPhrase, that.origPhrase) &&
                Objects.equals(normalizedPhrase, that.normalizedPhrase);
    }

    @Override
    public int hashCode() {

        return Objects.hash(origPhrase, normalizedPhrase);
    }
}
