package ru.yandex.direct.core.entity.placements.model1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BlockSize {

    public static final String WIDTH_PROPERTY = "width";
    public static final String HEIGHT_PROPERTY = "height";

    @JsonProperty(WIDTH_PROPERTY)
    private final Integer width;

    @JsonProperty(HEIGHT_PROPERTY)
    private final Integer height;

    @JsonCreator
    public BlockSize(@JsonProperty(WIDTH_PROPERTY) Integer width, @JsonProperty(HEIGHT_PROPERTY) Integer height) {
        this.width = width;
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    @Override
    public String toString() {
        return width + "x" + height;
    }
}
