package ru.yandex.direct.core.entity.placements.model1;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.i18n.Language;

import static ru.yandex.direct.core.entity.placements.model1.GeoBlock.ADDRESS_TRANSLATIONS_PROPERTY;

public class DbIndoorBlockData extends DbPlacementBlockData {

    @JsonProperty("address")
    private String address;

    @JsonProperty(ADDRESS_TRANSLATIONS_PROPERTY)
    private Map<Language, String> addressTranslations;

    @JsonProperty("coordinates")
    private String coordinates;

    @JsonProperty("resolution")
    private BlockSize resolution;

    @JsonProperty("aspectRatio")
    private List<Integer> aspectRatio;

    @JsonProperty("photos")
    private List<PlacementPhoto> photos;

    @JsonProperty("isHidden")
    private Boolean hidden;

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public DbIndoorBlockData withAddress(String address) {
        this.address = address;
        return this;
    }

    public Map<Language, String> getAddressTranslations() {
        return addressTranslations;
    }

    public void setAddressTranslations(Map<Language, String> addressTranslations) {
        this.addressTranslations = addressTranslations;
    }

    public DbIndoorBlockData withAddressTranslations(Map<Language, String> addressTranslations) {
        this.addressTranslations = addressTranslations;
        return this;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public DbIndoorBlockData withCoordinates(String coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    public BlockSize getResolution() {
        return resolution;
    }

    public void setResolution(BlockSize resolution) {
        this.resolution = resolution;
    }

    public DbIndoorBlockData withResolution(BlockSize resolution) {
        this.resolution = resolution;
        return this;
    }

    public List<Integer> getAspectRatio() {
        return aspectRatio;
    }

    public DbIndoorBlockData withAspectRatio(List<Integer> aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public DbIndoorBlockData withPhotos(List<PlacementPhoto> photos) {
        this.photos = photos;
        return this;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public DbIndoorBlockData withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public DbIndoorBlockData withSizes(List<BlockSize> sizes) {
        return (DbIndoorBlockData) super.withSizes(sizes);
    }
}
