package ru.yandex.direct.core.entity.placements.model1;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.i18n.Language;

import static ru.yandex.direct.core.entity.placements.model1.GeoBlock.ADDRESS_TRANSLATIONS_PROPERTY;

public class DbOutdoorBlockData extends DbPlacementBlockData {

    @JsonProperty("address")
    private String address;

    @JsonProperty(ADDRESS_TRANSLATIONS_PROPERTY)
    private Map<Language, String> addressTranslations;

    @JsonProperty("coordinates")
    private String coordinates;

    @JsonProperty("resolution")
    private BlockSize resolution;

    @JsonProperty("direction")
    private Integer direction;

    @JsonProperty("width")
    private Double width;

    @JsonProperty("height")
    private Double height;

    @JsonProperty("duration")
    private Double duration;

    @JsonProperty("photos")
    private List<PlacementPhoto> photos;

    @JsonProperty("isHidden")
    private Boolean hidden;

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public DbOutdoorBlockData withAddress(String address) {
        this.address = address;
        return this;
    }

    public Map<Language, String> getAddressTranslations() {
        return addressTranslations;
    }

    public void setAddressTranslations(Map<Language, String> addressTranslations) {
        this.addressTranslations = addressTranslations;
    }

    public DbOutdoorBlockData withAddressTranslations(Map<Language, String> addressTranslations) {
        this.addressTranslations = addressTranslations;
        return this;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public DbOutdoorBlockData withCoordinates(String coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    public BlockSize getResolution() {
        return resolution;
    }

    public void setResolution(BlockSize resolution) {
        this.resolution = resolution;
    }

    public DbOutdoorBlockData withResolution(BlockSize resolution) {
        this.resolution = resolution;
        return this;
    }

    public Integer getDirection() {
        return direction;
    }

    public DbOutdoorBlockData withDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    public Double getWidth() {
        return width;
    }

    public DbOutdoorBlockData withWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getHeight() {
        return height;
    }

    public DbOutdoorBlockData withHeight(Double height) {
        this.height = height;
        return this;
    }

    public Double getDuration() {
        return duration;
    }

    public DbOutdoorBlockData withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public DbOutdoorBlockData withPhotos(List<PlacementPhoto> photos) {
        this.photos = photos;
        return this;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public DbOutdoorBlockData withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public DbOutdoorBlockData withSizes(List<BlockSize> sizes) {
        return (DbOutdoorBlockData) super.withSizes(sizes);
    }
}
