package ru.yandex.direct.core.entity.placements.model1;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.Language;

@ParametersAreNonnullByDefault
public class IndoorBlock extends PlacementBlock implements GeoBlock<IndoorBlock> {

    public static final String COORDINATES_PROPERTY = "coordinates";
    public static final String RESOLUTION_PROPERTY = "resolution";
    public static final String FACILITY_TYPE_PROPERTY = "facilityType";
    public static final String ZONE_CATEGORY_PROPERTY = "zoneCategory";
    public static final String ASPECT_RATIO_PROPERTY = "aspectRatio";
    public static final String PHOTOS_PROPERTY = "photos";

    private final Long geoId;
    private final String address;
    private final Map<Language, String> addressTranslations;
    private final String coordinates;
    private final BlockSize resolution;
    private final Integer facilityType;
    private final Integer zoneCategory;
    private final List<Integer> aspectRatio;
    private final List<PlacementPhoto> photos;
    private final Boolean hidden;

    public IndoorBlock(Long pageId, Long blockId, LocalDateTime lastChange, boolean isDeleted, List<BlockSize> sizes,
                       @Nullable Long geoId, String address, @Nullable Map<Language, String> addressTranslations,
                       String coordinates, BlockSize resolution, Integer facilityType, Integer zoneCategory,
                       List<Integer> aspectRatio, List<PlacementPhoto> photos, Boolean hidden) {
        super(pageId, blockId, null, lastChange, isDeleted, sizes);
        this.geoId = geoId;
        this.address = address;
        this.addressTranslations = addressTranslations;
        this.coordinates = coordinates;
        this.resolution = resolution;
        this.facilityType = facilityType;
        this.zoneCategory = zoneCategory;
        this.aspectRatio = aspectRatio;
        this.photos = photos;
        this.hidden = hidden;
    }

    @Override
    public Long getGeoId() {
        return geoId;
    }

    @Override
    public String getAddress() {
        return address;
    }

    @Override
    public Map<Language, String> getAddressTranslations() {
        return addressTranslations;
    }

    @Override
    public String getCoordinates() {
        return coordinates;
    }

    public BlockSize getResolution() {
        return resolution;
    }

    public Integer getFacilityType() {
        return facilityType;
    }

    public Integer getZoneCategory() {
        return zoneCategory;
    }

    public List<Integer> getAspectRatio() {
        return aspectRatio;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public Boolean getHidden() {
        return hidden;
    }

    @Override
    public IndoorBlock markDeleted() {
        return new IndoorBlock(getPageId(), getBlockId(), getLastChange(), true, getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, zoneCategory,
                aspectRatio, photos, hidden);
    }

    @Override
    public IndoorBlock withAddress(String address) {
        return new IndoorBlock(getPageId(), getBlockId(), getLastChange(), isDeleted(), getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, zoneCategory,
                aspectRatio, photos, hidden);
    }

    @Override
    public IndoorBlock withAddressTranslations(Map<Language, String> addressTranslations) {
        return new IndoorBlock(getPageId(), getBlockId(), getLastChange(), isDeleted(), getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, zoneCategory,
                aspectRatio, photos, hidden);
    }
}
