package ru.yandex.direct.core.entity.placements.model1;

import java.util.EnumSet;
import java.util.Set;

public enum IndoorFacilityType implements Codable {
    MALL(1),
    GROCERY_RETAIL(2),
    DEPARTMENT_RETAIL(3),
    OFFICE_CENTER(4),
    RESIDENTAL_REAL_ESTATE(5),
    AIRPORT(6),
    STATION(7),
    TAXI(8),
    METRO(9),
    GROUND_TRANSPORTATION(10),
    FILLING_STATION(11),
    PHARMACY(12),
    ENTERTAINMENT(13),
    SUPERMARKET(14),
    FINANCIALS(15),
    HORECA(16),
    BEAUTY_SALON(17),
    FITNESS_CENTER(18),
    OTHER(19),
    // ho - отели, re - рестораны, ca - кафе
    UNKNOWN(1000);

    private int code;

    IndoorFacilityType(int code) {
        this.code = code;
    }


    public int getCode() {
        return code;
    }

    public static IndoorFacilityType fromCode(int code) {
        Set<IndoorFacilityType> types = EnumSet.allOf(IndoorFacilityType.class);
        for (IndoorFacilityType type : types) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return IndoorFacilityType.UNKNOWN;
    }
}
