package ru.yandex.direct.core.entity.placements.model1;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class IndoorPlacement extends Placement<IndoorBlock> {

    public IndoorPlacement(Long id, String domain, String caption, String login, @Nullable String operatorName,
                           boolean isYandexPage, boolean isDeleted, boolean isTesting, List<IndoorBlock> blocks,
                           List<String> mirrors) {
        super(id, PlacementType.INDOOR, domain, caption, login, operatorName, isYandexPage, isDeleted, isTesting,
                blocks, mirrors);
    }

    @Override
    @SuppressWarnings("ConstantConditions")
    public IndoorPlacement replaceBlocks(List<IndoorBlock> newBlocks) {
        checkArgument(newBlocks != null, "new block list must not be null");
        checkArgument(newBlocks.stream().allMatch(b -> b instanceof IndoorBlock),
                "all blocks for indoor placement must have type IndoorBlock");
        return new IndoorPlacement(getId(), getDomain(), getCaption(), getLogin(), getOperatorName(), isYandexPage(),
                isDeleted(), isTesting(), newBlocks, getMirrors());
    }
}
