package ru.yandex.direct.core.entity.placements.model1;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.Language;

@ParametersAreNonnullByDefault
public class OutdoorBlock extends PlacementBlock implements GeoBlock<OutdoorBlock> {

    public static final String ADDRESS_PROPERTY = "address";
    public static final String COORDINATES_PROPERTY = "coordinates";
    public static final String RESOLUTION_PROPERTY = "resolution";
    public static final String FACILITY_TYPE_PROPERTY = "facilityType";
    public static final String DIRECTION_PROPERTY = "direction";
    public static final String WIDTH_PROPERTY = "width";
    public static final String HEIGHT_PROPERTY = "height";
    public static final String DURATION_PROPERTY = "duration";
    public static final String PHOTOS_PROPERTY = "photos";

    private final Long geoId;
    private final String address;
    private final Map<Language, String> addressTranslations;
    private final String coordinates;
    private final BlockSize resolution;
    private final Integer facilityType;
    private final Integer direction;
    private final Double width;
    private final Double height;
    private final Double duration;
    private final List<PlacementPhoto> photos;
    private final Boolean hidden;

    public OutdoorBlock(Long pageId, Long blockId, String blockCaption, LocalDateTime lastChange, boolean isDeleted,
                        List<BlockSize> sizes, @Nullable Long geoId, String address,
                        @Nullable Map<Language, String> addressTranslations, String coordinates, BlockSize resolution,
                        Integer facilityType, Integer direction, Double width, Double height, Double duration,
                        List<PlacementPhoto> photos, Boolean hidden) {
        super(pageId, blockId, blockCaption, lastChange, isDeleted, sizes);
        this.geoId = geoId;
        this.resolution = resolution;
        this.coordinates = coordinates;
        this.address = address;
        this.addressTranslations = addressTranslations;
        this.facilityType = facilityType;
        this.direction = direction;
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.photos = photos;
        this.hidden = hidden;
    }

    @Nullable
    public Long getGeoId() {
        return geoId;
    }

    @Override
    public String getAddress() {
        return address;
    }

    @Override
    public Map<Language, String> getAddressTranslations() {
        return addressTranslations;
    }

    @Override
    public String getCoordinates() {
        return coordinates;
    }

    public BlockSize getResolution() {
        return resolution;
    }

    public Integer getFacilityType() {
        return facilityType;
    }

    public Integer getDirection() {
        return direction;
    }

    public Double getWidth() {
        return width;
    }

    public Double getHeight() {
        return height;
    }

    public Double getDuration() {
        return duration;
    }

    public List<PlacementPhoto> getPhotos() {
        return photos;
    }

    public Boolean getHidden() {
        return hidden;
    }

    @Override
    public OutdoorBlock markDeleted() {
        return new OutdoorBlock(getPageId(), getBlockId(), getBlockCaption(), getLastChange(), true, getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, direction, width, height,
                duration, photos, hidden);
    }

    @Override
    public OutdoorBlock withAddress(String address) {
        return new OutdoorBlock(getPageId(), getBlockId(), getBlockCaption(), getLastChange(), isDeleted(), getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, direction, width, height,
                duration, photos, hidden);
    }

    @Override
    public OutdoorBlock withAddressTranslations(Map<Language, String> addressTranslations) {
        return new OutdoorBlock(getPageId(), getBlockId(), getBlockCaption(), getLastChange(), isDeleted(), getSizes(),
                geoId, address, addressTranslations, coordinates, resolution, facilityType, direction, width, height,
                duration, photos, hidden);
    }
}
