package ru.yandex.direct.core.entity.placements.model1;

import java.util.EnumSet;
import java.util.Set;

public enum OutdoorFacilityType implements Codable {
    BILLBOARD(1),
    SUPERSITE(2),
    MEDIAFACADE(3),
    CITYBOARD(4),
    CITYFORMAT(5),
    UNKNOWN(1000);

    private int code;

    OutdoorFacilityType(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static OutdoorFacilityType fromCode(int code) {
        Set<OutdoorFacilityType> types = EnumSet.allOf(OutdoorFacilityType.class);
        for (OutdoorFacilityType type : types) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return OutdoorFacilityType.UNKNOWN;
    }
}
