package ru.yandex.direct.core.entity.placements.model1;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class OutdoorPlacement extends Placement<OutdoorBlock> {

    public OutdoorPlacement(Long id, String domain, String caption, String login, @Nullable String operatorName,
                            boolean isYandexPage, boolean isDeleted, boolean isTesting, List<OutdoorBlock> blocks,
                            List<String> mirrors) {
        super(id, PlacementType.OUTDOOR, domain, caption, login, operatorName, isYandexPage, isDeleted, isTesting,
                blocks, mirrors);
    }

    @Override
    @SuppressWarnings("ConstantConditions")
    public OutdoorPlacement replaceBlocks(List<OutdoorBlock> newBlocks) {
        checkArgument(newBlocks != null, "new block list must not be null");
        checkArgument(newBlocks.stream().allMatch(b -> b instanceof OutdoorBlock),
                "all blocks for outdoor placement must have type OutdoorBlock");
        return new OutdoorPlacement(getId(), getDomain(), getCaption(), getLogin(), getOperatorName(), isYandexPage(),
                isDeleted(), isTesting(), newBlocks, getMirrors());
    }
}
