package ru.yandex.direct.core.entity.placements.model1;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class Placement<B extends PlacementBlock> {

    public static final String ID_PROPERTY = "id";
    public static final String DOMAIN_PROPERTY = "domain";
    public static final String CAPTION_PROPERTY = "caption";
    public static final String LOGIN_PROPERTY = "login";
    public static final String BLOCKS_PROPERTY = "blocks";

    private final Long id;
    private final PlacementType type;
    private final String domain;
    private final String caption;
    private final String login;
    private final String operatorName;
    private final boolean isYandexPage;
    private final boolean isDeleted;
    private final boolean isTesting;
    private final ImmutableList<B> blocks;
    private final List<String> mirrors;

    public Placement(Long id, @Nullable PlacementType type, String domain, String caption,
                     String login, @Nullable String operatorName, boolean isYandexPage, boolean isDeleted,
                     boolean isTesting,
                     List<B> blocks, List<String> mirrors) {
        this.mirrors = nvl(mirrors, emptyList());
        //noinspection ConstantConditions
        checkArgument(id != null, "id must not be null");
        //noinspection ConstantConditions
        checkArgument(blocks != null, "blocks must not be null");
        checkArgument(blocks.stream().allMatch(block -> block.getPageId().equals(id)),
                "blocks pageIds must be equal to pageId");
        this.id = id;
        this.type = type;
        this.domain = domain;
        this.caption = caption;
        this.login = login;
        this.operatorName = operatorName;
        this.isYandexPage = isYandexPage;
        this.isDeleted = isDeleted;
        this.isTesting = isTesting;
        this.blocks = ImmutableList.copyOf(blocks);
    }

    public Long getId() {
        return id;
    }

    @Nullable
    public PlacementType getType() {
        return type;
    }

    public String getDomain() {
        return domain;
    }

    public String getCaption() {
        return caption;
    }

    public boolean isYandexPage() {
        return isYandexPage;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public boolean isTesting() {
        return isTesting;
    }

    public ImmutableList<B> getBlocks() {
        return blocks;
    }

    public Placement<B> replaceBlocks(List<B> newBlocks) {
        return new Placement<>(id, type, domain, caption, login, operatorName, isYandexPage, isDeleted, isTesting,
                newBlocks, mirrors);
    }

    public List<String> getMirrors() {
        return mirrors;
    }

    public String getLogin() {
        return login;
    }

    public String getOperatorName() {
        return operatorName;
    }
}
