package ru.yandex.direct.core.entity.placements.model1;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class PlacementBlock implements Block {

    public static final String BLOCK_ID_PROPERTY = "blockId";
    public static final String SIZES_PROPERTY = "sizes";

    private final Long pageId;
    private final Long blockId;
    private final String blockCaption;
    private final LocalDateTime lastChange;
    private final boolean isDeleted;
    private final ImmutableList<BlockSize> sizes;

    public PlacementBlock(Long pageId, Long blockId, String blockCaption, LocalDateTime lastChange, boolean isDeleted,
                          List<BlockSize> sizes) {
        //noinspection ConstantConditions
        checkArgument(pageId != null, "pageId must not be null");
        //noinspection ConstantConditions
        checkArgument(blockId != null, "blockId must not be null");
        //noinspection ConstantConditions
        checkArgument(sizes != null, "sizes must not be null");
        //noinspection ConstantConditions
        checkArgument(lastChange != null, "lastChange must not be null");
        this.pageId = pageId;
        this.blockId = blockId;
        this.blockCaption = blockCaption;
        this.lastChange = lastChange;
        this.isDeleted = isDeleted;
        this.sizes = ImmutableList.copyOf(sizes);
    }

    @Override
    public Long getPageId() {
        return pageId;
    }

    @Override
    public Long getBlockId() {
        return blockId;
    }

    @Override
    public String getBlockCaption() { return blockCaption; }

    @Override
    public LocalDateTime getLastChange() {
        return lastChange;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public List<BlockSize> getSizes() {
        return sizes;
    }

    public PlacementBlock markDeleted() {
        return new PlacementBlock(pageId, blockId, blockCaption, lastChange, true, sizes);
    }
}
