package ru.yandex.direct.core.entity.placements.model1;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public final class PlacementBlockKey {

    private final Long pageId;
    private final Long blockId;

    @SuppressWarnings("ConstantConditions")
    private PlacementBlockKey(Long pageId, Long blockId) {
        checkArgument(pageId != null, "pageId is required");
        checkArgument(blockId != null, "blockId is required");
        this.pageId = pageId;
        this.blockId = blockId;
    }

    public static PlacementBlockKey of(Long pageId, Long blockId) {
        return new PlacementBlockKey(pageId, blockId);
    }

    public static PlacementBlockKey of(Block block) {
        return new PlacementBlockKey(block.getPageId(), block.getBlockId());
    }

    public Long getPageId() {
        return pageId;
    }

    public Long getBlockId() {
        return blockId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PlacementBlockKey that = (PlacementBlockKey) o;
        return Objects.equals(pageId, that.pageId) &&
                Objects.equals(blockId, that.blockId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageId, blockId);
    }

    @Override
    public String toString() {
        return "PlacementBlockKey{" +
                "pageId=" + pageId +
                ", blockId=" + blockId +
                '}';
    }
}
