package ru.yandex.direct.core.entity.placements.model1;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PlacementFormat {

    public static final String WIDTH_PROPERTY = "width";
    public static final String HEIGHT_PROPERTY = "height";
    public static final String PATH_PROPERTY = "path";

    @JsonProperty(WIDTH_PROPERTY)
    private Integer width;
    @JsonProperty(HEIGHT_PROPERTY)
    private Integer height;
    @JsonProperty(PATH_PROPERTY)
    private String path;

    public Integer getWidth() {
        return width;
    }

    public PlacementFormat withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public PlacementFormat withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public String getPath() {
        return path;
    }

    public PlacementFormat withPath(String path) {
        this.path = path;
        return this;
    }
}
