package ru.yandex.direct.core.entity.placements.model1;

import java.util.EnumSet;
import java.util.Set;

public enum ZoneCategory implements Codable {
    CASH_ZONE(1),
    VEGETABLES_AND_FRUITS(2),
    MEAT_FISH(3),
    DAIRY_PRODUCTS(4),
    ALCOHOLIC_BEVERAGES(5),
    CONFECTIONERY(6),
    GROCERY(7),
    BABY_FOOD(8),
    CHEMISTRY(9),
    COSMETIC(10),
    FOR_HOME(11),
    PET_PRODUCTS(12),
    SPORT(13),
    CLOTHES(14),
    SHOES(15),
    LOBBY(16),
    OTHER(17),
    UNKNOWN(1000);

    private int code;

    ZoneCategory(int code) {
        this.code = code;
    }


    public int getCode() {
        return code;
    }

    public static ZoneCategory fromCode(int code) {
        Set<ZoneCategory> types = EnumSet.allOf(ZoneCategory.class);
        for (ZoneCategory type : types) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return ZoneCategory.UNKNOWN;
    }
}
