package ru.yandex.direct.core.entity.placements.service;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.placements.model1.GeoBlock;
import ru.yandex.direct.i18n.Language;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.Translator;

public class GeoBlockAddressTranslatable implements Translatable {

    private final GeoBlock<?> block;

    public GeoBlockAddressTranslatable(GeoBlock<?> block) {
        this.block = block;
    }

    @Override
    public String translate(Translator translator) {
        Language language = Language.fromLocale(translator.getLocale());
        String fallbackTranslation = block.getAddress();

        if (block.getAddressTranslations() == null || language == Language.RU) {
            return fallbackTranslation;
        }

        return EntryStream.of(block.getAddressTranslations())
                .filterKeys(translationLanguage -> translationLanguage.equals(language))
                .values()
                .findFirst()
                .orElse(fallbackTranslation);
    }
}
