package ru.yandex.direct.core.entity.placements.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

@ParametersAreNonnullByDefault
public interface IndoorFacilityTypeTranslations extends TranslationBundle {
    IndoorFacilityTypeTranslations INSTANCE = I18NBundle.implement(IndoorFacilityTypeTranslations.class);

    @TranslationStub("торговые центры и моллы")
    Translatable mall();

    @TranslationStub("продуктовый ритейл")
    Translatable groceryRetail();

    @TranslationStub("отделы розничной торговли")
    Translatable departmentRetail();

    @TranslationStub("офисные центры")
    Translatable officeCenter();

    @TranslationStub("жилая недвижимость")
    Translatable residentalRealEstate();

    @TranslationStub("аэропорты")
    Translatable airport();

    @TranslationStub("вокзалы")
    Translatable station();

    @TranslationStub("такси")
    Translatable taxi();

    @TranslationStub("метро")
    Translatable metro();

    @TranslationStub("наземный транспорт")
    Translatable groundTransportation();

    @TranslationStub("АЗС")
    Translatable fillingStation();

    @TranslationStub("аптеки")
    Translatable pharmacy();

    @TranslationStub("развлечения (кинотеатры, клубы и пр.)")
    Translatable entertainment();

    @TranslationStub("супермаркеты, гипермаркеты")
    Translatable supermarket();

    @TranslationStub("финансовые организации")
    Translatable financials();

    @TranslationStub("HoReCa (отели, рестораны, кафе)")
    Translatable horeca();

    @TranslationStub("салоны красоты")
    Translatable beautySalon();

    @TranslationStub("фитнес-центры")
    Translatable fitnessCenter();

    @TranslationStub("другое")
    Translatable other();

    @TranslationStub("неизвестный тип")
    Translatable unknown();
}
