package ru.yandex.direct.core.entity.placements.service;

import java.util.EnumMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.placements.model1.IndoorFacilityType;
import ru.yandex.direct.i18n.Translatable;


@Service
public class TranslateFacilityTypeIndoorService implements PlacementsTranslateService<IndoorFacilityType> {

    private final TranslationService translationService;

    private static final IndoorFacilityTypeTranslations TRANSLATIONS = IndoorFacilityTypeTranslations.INSTANCE;
    private static final Map<IndoorFacilityType, Translatable> NAMES = new EnumMap<>(IndoorFacilityType.class);

    static {
        NAMES.put(IndoorFacilityType.MALL, TRANSLATIONS.mall());
        NAMES.put(IndoorFacilityType.GROCERY_RETAIL, TRANSLATIONS.groceryRetail());
        NAMES.put(IndoorFacilityType.DEPARTMENT_RETAIL, TRANSLATIONS.departmentRetail());
        NAMES.put(IndoorFacilityType.OFFICE_CENTER, TRANSLATIONS.officeCenter());
        NAMES.put(IndoorFacilityType.RESIDENTAL_REAL_ESTATE, TRANSLATIONS.residentalRealEstate());
        NAMES.put(IndoorFacilityType.AIRPORT, TRANSLATIONS.airport());
        NAMES.put(IndoorFacilityType.STATION, TRANSLATIONS.station());
        NAMES.put(IndoorFacilityType.TAXI, TRANSLATIONS.taxi());
        NAMES.put(IndoorFacilityType.METRO, TRANSLATIONS.metro());
        NAMES.put(IndoorFacilityType.GROUND_TRANSPORTATION, TRANSLATIONS.groundTransportation());
        NAMES.put(IndoorFacilityType.FILLING_STATION, TRANSLATIONS.fillingStation());
        NAMES.put(IndoorFacilityType.PHARMACY, TRANSLATIONS.pharmacy());
        NAMES.put(IndoorFacilityType.ENTERTAINMENT, TRANSLATIONS.entertainment());
        NAMES.put(IndoorFacilityType.SUPERMARKET, TRANSLATIONS.supermarket());
        NAMES.put(IndoorFacilityType.FINANCIALS, TRANSLATIONS.financials());
        NAMES.put(IndoorFacilityType.HORECA, TRANSLATIONS.horeca());
        NAMES.put(IndoorFacilityType.BEAUTY_SALON, TRANSLATIONS.beautySalon());
        NAMES.put(IndoorFacilityType.FITNESS_CENTER, TRANSLATIONS.fitnessCenter());
        NAMES.put(IndoorFacilityType.OTHER, TRANSLATIONS.other());
        NAMES.put(IndoorFacilityType.UNKNOWN, TRANSLATIONS.unknown());
    }

    @Autowired
    public TranslateFacilityTypeIndoorService(TranslationService translationService) {
        this.translationService = translationService;
    }

    @Override
    public String getTranslation(IndoorFacilityType type) {
        return translationService.translate(NAMES.get(type));
    }

    public boolean hasTranslation(int facilityType) {
        IndoorFacilityType internalType = IndoorFacilityType.fromCode(facilityType);
        return internalType != IndoorFacilityType.UNKNOWN && NAMES.containsKey(internalType);
    }
}
