package ru.yandex.direct.core.entity.placements.service;

import java.util.EnumMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.placements.model1.OutdoorFacilityType;
import ru.yandex.direct.i18n.Translatable;

@Service
public class TranslateFacilityTypeOutdoorService implements PlacementsTranslateService<OutdoorFacilityType> {

    private final TranslationService translationService;

    private static final OutdoorFacilityTypeTranslations TRANSLATIONS = OutdoorFacilityTypeTranslations.INSTANCE;
    private static final Map<OutdoorFacilityType, Translatable> NAMES = new EnumMap<>(OutdoorFacilityType.class);

    static {
        NAMES.put(OutdoorFacilityType.BILLBOARD, TRANSLATIONS.billboard());
        NAMES.put(OutdoorFacilityType.SUPERSITE, TRANSLATIONS.supersite());
        NAMES.put(OutdoorFacilityType.MEDIAFACADE, TRANSLATIONS.mediafacade());
        NAMES.put(OutdoorFacilityType.CITYBOARD, TRANSLATIONS.cityboard());
        NAMES.put(OutdoorFacilityType.CITYFORMAT, TRANSLATIONS.cityformat());
        NAMES.put(OutdoorFacilityType.UNKNOWN, TRANSLATIONS.unknown());
    }

    @Autowired
    public TranslateFacilityTypeOutdoorService(TranslationService translationService) {
        this.translationService = translationService;
    }

    @Override
    public String getTranslation(OutdoorFacilityType type) {
        return translationService.translate(NAMES.get(type));
    }

    public boolean hasTranslation(int facilityType) {
        OutdoorFacilityType internalType = OutdoorFacilityType.fromCode(facilityType);
        return internalType != OutdoorFacilityType.UNKNOWN && NAMES.containsKey(internalType);
    }
}
