package ru.yandex.direct.core.entity.placements.service;

import java.util.EnumMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.placements.model1.ZoneCategory;
import ru.yandex.direct.i18n.Translatable;

@Service
public class TranslateZoneCategoryService implements PlacementsTranslateService<ZoneCategory> {

    private final TranslationService translationService;

    private static final ZoneCategoryTranslations TRANSLATIONS = ZoneCategoryTranslations.INSTANCE;
    private static final Map<ZoneCategory, Translatable> NAMES = new EnumMap<>(ZoneCategory.class);

    static {
        NAMES.put(ZoneCategory.CASH_ZONE, TRANSLATIONS.cashZone());
        NAMES.put(ZoneCategory.VEGETABLES_AND_FRUITS, TRANSLATIONS.vegetablesAndFruits());
        NAMES.put(ZoneCategory.MEAT_FISH, TRANSLATIONS.meatFish());
        NAMES.put(ZoneCategory.DAIRY_PRODUCTS, TRANSLATIONS.dairyProducts());
        NAMES.put(ZoneCategory.ALCOHOLIC_BEVERAGES, TRANSLATIONS.alcoholicBeverages());
        NAMES.put(ZoneCategory.CONFECTIONERY, TRANSLATIONS.confectionery());
        NAMES.put(ZoneCategory.GROCERY, TRANSLATIONS.grocery());
        NAMES.put(ZoneCategory.BABY_FOOD, TRANSLATIONS.babyFood());
        NAMES.put(ZoneCategory.CHEMISTRY, TRANSLATIONS.chemistry());
        NAMES.put(ZoneCategory.COSMETIC, TRANSLATIONS.cosmetic());
        NAMES.put(ZoneCategory.FOR_HOME, TRANSLATIONS.forHome());
        NAMES.put(ZoneCategory.PET_PRODUCTS, TRANSLATIONS.petProducts());
        NAMES.put(ZoneCategory.SPORT, TRANSLATIONS.sport());
        NAMES.put(ZoneCategory.CLOTHES, TRANSLATIONS.clothes());
        NAMES.put(ZoneCategory.SHOES, TRANSLATIONS.shoes());
        NAMES.put(ZoneCategory.LOBBY, TRANSLATIONS.lobby());
        NAMES.put(ZoneCategory.OTHER, TRANSLATIONS.other());

        NAMES.put(ZoneCategory.UNKNOWN, TRANSLATIONS.unknown());
    }

    @Autowired
    public TranslateZoneCategoryService(TranslationService translationService) {
        this.translationService = translationService;
    }

    public String getTranslation(ZoneCategory type) {
        return translationService.translate(NAMES.get(type));
    }

    public boolean hasTranslation(int facilityType) {
        ZoneCategory internalType = ZoneCategory.fromCode(facilityType);
        return internalType != ZoneCategory.UNKNOWN && NAMES.containsKey(internalType);
    }
}
